NAME
    RISCOS::Time --perl interface to RISC OS time SWIs

SYNOPSIS
        use RISCOS::Time qw (time2utc time2local);
        print 'symtable updated ', scalar time2local $time;
        print 'script started ' . time2utc (0);	# Auto converts from "age"


DESCRIPTION
    This module provides perl interface to the SWIs
    `OS_ConvertStandardDateAndTime',
    `Territory_ConvertTimeToUTCOrdinals' and
    `Territory_ConvertTimeToOrdinals' and functions to convert
    between different formats for storing time information.

    Time formats currently understood are

    * numeric ages as returned by perl's `-A', `-C' and `-M' functions

    4 byte scalars - Unix times, seconds starting from 1st January 1970

    5 byte scalars - RISC OS times, centiseconds starting from 1st January 1900

    6 byte scalars - RISC OS times, as stored in `ALF' files.


    Clearly it is not possible to automatically distinguish between
    all these formats so where guessing is necessary the following
    heuristics are used:

    *   If *time* is composed soley of numeric characters (0-9, "-" and
        ".") then it is assumed to be an age in days since the time
        the script started running (see the "$^T" entry in the
        perlvar manpage). Clearly there is possible ambiguity with
        RISC OS 5 byte ages that happen to be eqactly 5 characters
        and composed of legal numeric characters. However the most
        recent 5 byte time which could be confused is `"99999"',
        23:17:53.85 on Friday 18th November 1977, which is likely to
        predate most stamped files by about a decade.

    *   Otherwise `if (length $time == 5)' then `$time' is assumed to be
        a 5 byte RISC OS time, encoded as centiseconds since
        1900/1/1.

    *   `if (length $time == 4)' then `$time' is taken to be a 4 byte
        Unix time, seconds since 1970/1/1 `pack'ed as `'I''.

    *   `if (length $time == 6)' then `$time' is expected to be a 6 byte
        time as stored in `ALF' files, also centiseconds since
        1900/1/1. If the MSB is not 0 the time is rejected,
        otherwise it is treated as the equivalent 5 byte RISC OS
        time.


  SWI interface

    As the SWI interface functions are expect to be used with native
    times if `length $time == 5' then it is taken as a RISC OS time,
    taking priority over the guessing heuristic.

    standard_date_and_time <time>
        calls `OS_ConvertStandardDateAndTime' for *time*, returning
        the string representation of that time for the local
        timezone (the format being set by `<Sys$DateFormat>').

    time2utc <time>
        calls `Territory_ConvertTimeToUTCOrdinals' for *time*,
        returning an array of integers, adjusted to be consistent
        with the return array from `gmtime'.

            #  0    1    2     3     4    5     6     7
            ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) = time2utc($time);


        In particular this means that `$mon' has the range 0..11 and
        `$wday' has the range 0..6 with Sunday as day 0. Note
        `$year' is the number of years since 1900, not simply the
        last two digits of the year. If `length $time == 4' calls
        `gmtime' directly, but drops the 9th element ("is daylight
        saving time").

    time2local <time> [, <territory>]
        calls `Territory_ConvertTimeToOrdinals' for *time* to
        convert to local times. In scalar context behaves as a call
        to `standard_date_and_time', in array context returns an
        array as described in `time2utc'. If `length $time == 4'
        calls `localtime' directly. *territory* defaults to `-1' -
        the current territory.

        Support for territories other than `-1' (the current
        territory) is rather limited - currently territories may
        only be used in array context and must be specified by
        number only, rather than name. Calls in scalar context may
        only use the current territory. (Otherwise the script `die's
        with an error).

    time2_raw <swi_number>, <time> [, <territory>]
        calls the supplied SWI (which is expected to be
        `Territory_ConvertTimeToUTCOrdinals' or
        `Territory_ConvertTimeToOrdinals') and returns an array of
        integers

            #  0     1    2     3     4    5    6     7    8
            ($csec,$sec,$min,$hour,$mday,$mon,$year,$wday,$yday)


        where the ranges for `$mon', `$wday' and `$yday' run from 1
        upwards (*c.f.* 0 upwards for the other subroutines and the
        perl builtins) and `$year' is the full Gregorian year
        (rather then the number of years since 1900).


    Values are returned consistent with ANSI C and perl's idea of
    the base values for days of the week, days of the year *etc.*
    from `time2utc' and `time2local' - the native RISC OS values are
    available from `time2_raw'.

  Conversion functions

    13 functions are provided to convert between different time
    formats. In scalar context all convert only the first argument,
    in list context a list of conversions corresponding to the
    argument list.

    time_guess2riscos
        Each argument is processed according to the guessing
        heuristics to determine which conversion to use.

    time_age2cs

    time_age2riscos

    time_age2unix

    time_cs2age

    time_cs2riscos

    time_cs2unix

    time_riscos2age

    time_riscos2cs

    time_riscos2unix

    time_unix2age

    time_unix2cs

    time_unix2riscos
        Arguments are converted from the first named format to the
        second, where formats are

    age     numeric ages as returned by perl's `-A', `-C' and `-M'
            functions (see the "-X" entry in the perlfunc manpage)in
            days since the script start time (`$^T').

    cs      centiseconds since 1900/1/1 expressed as a number.

    riscos  centiseconds since 1900/1/1 packed as 5 bytes.

    unix    seconds since 1970/1/1 packed as 4 bytes.


  Constants

    `RISCOS::Time' is able to export these "useful" constants:

    $s_1900to1970
        `2208988800', the number of seconds between Janaury 1st 1900
        and 1970.

    $seconds_per_day
        `86400', the number of seconds in a day.


BUGS
    Support for territories other than the current territory is very
    limited. It might help if Acorn supplied more than one territory
    on the standard UK machine.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

