/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionFactory;
import edu.stanford.nlp.util.ErasureUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Maps {
    public static <K, V> void putIntoValueHashSet(Map<K, Set<V>> map, K key, V value) {
        CollectionFactory factory = CollectionFactory.hashSetFactory();
        Maps.putIntoValueCollection(map, key, value, factory);
    }

    public static <K, V> void putIntoValueArrayList(Map<K, List<V>> map, K key, V value) {
        CollectionFactory factory = CollectionFactory.arrayListFactory();
        Maps.putIntoValueCollection(map, key, value, factory);
    }

    public static <K, V, C extends Collection<V>> void putIntoValueCollection(Map<K, C> map, K key, V value, CollectionFactory<V> cf) {
        Collection c = (Collection)map.get(key);
        if (c == null) {
            c = (Collection)ErasureUtils.uncheckedCast(cf.newCollection());
            map.put(key, c);
        }
        c.add(value);
    }

    public static <X, Y, Z> Map<X, Z> compose(Map<X, Y> map1, Map<Y, Z> map2) {
        HashMap<X, Z> composedMap = new HashMap<X, Z>();
        for (X key : map1.keySet()) {
            composedMap.put(key, map2.get(map1.get(key)));
        }
        return composedMap;
    }

    public static <X, Y> Map<Y, X> invert(Map<X, Y> map) {
        HashMap<Y, X> invertedMap = new HashMap<Y, X>();
        for (Map.Entry<X, Y> entry : map.entrySet()) {
            X key = entry.getKey();
            Y value = entry.getValue();
            invertedMap.put(value, key);
        }
        return invertedMap;
    }

    public static <X, Y> Map<Y, Set<X>> invertSet(Map<X, Y> map) {
        HashMap invertedMap = new HashMap();
        for (Map.Entry<X, Y> entry : map.entrySet()) {
            X key = entry.getKey();
            Y value = entry.getValue();
            Maps.putIntoValueHashSet(invertedMap, value, key);
        }
        return invertedMap;
    }

    public static <K extends Comparable<? super K>, V> List<Map.Entry<K, V>> sortedEntries(Collection<Map.Entry<K, V>> entries) {
        ArrayList<Map.Entry<K, V>> entriesList = new ArrayList<Map.Entry<K, V>>(entries);
        Collections.sort(entriesList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                return ((Comparable)e1.getKey()).compareTo(e2.getKey());
            }
        });
        return entriesList;
    }

    public static <K extends Comparable<? super K>, V> List<Map.Entry<K, V>> sortedEntries(Map<K, V> map) {
        return Maps.sortedEntries(map.entrySet());
    }

    public static <K extends Comparable<K>, V> void toStringSorted(Map<K, V> map, StringBuilder builder) {
        builder.append("{");
        List<Map.Entry<K, V>> sortedProperties = Maps.sortedEntries(map);
        int index = 0;
        for (Map.Entry<K, V> entry : sortedProperties) {
            if (index > 0) {
                builder.append(", ");
            }
            builder.append(entry.getKey()).append("=").append(entry.getValue());
            ++index;
        }
        builder.append("}");
    }

    public static <K extends Comparable<K>, V> String toStringSorted(Map<K, V> map) {
        StringBuilder builder = new StringBuilder();
        Maps.toStringSorted(map, builder);
        return builder.toString();
    }

    public static <K, V> void removeKeys(Map<K, V> map, Collection<K> removekeys) {
        for (K k : removekeys) {
            map.remove(k);
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("a", "1");
        map1.put("b", "2");
        map1.put("c", "2");
        map1.put("d", "4");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("1", "x");
        map2.put("2", "y");
        map2.put("3", "z");
        System.out.println("map1: " + map1);
        System.out.println("invert(map1): " + Maps.invert(map1));
        System.out.println("invertSet(map1): " + Maps.invertSet(map1));
        System.out.println("map2: " + map2);
        System.out.println("compose(map1,map2): " + Maps.compose(map1, map2));
        HashMap setValues = new HashMap();
        HashMap listValues = new HashMap();
        Maps.putIntoValueArrayList(listValues, "a", "1");
        Maps.putIntoValueArrayList(listValues, "a", "1");
        Maps.putIntoValueArrayList(listValues, "a", "2");
        Maps.putIntoValueHashSet(setValues, "a", "1");
        Maps.putIntoValueHashSet(setValues, "a", "1");
        Maps.putIntoValueHashSet(setValues, "a", "2");
        System.out.println("listValues: " + listValues);
        System.out.println("setValues: " + setValues);
    }
}

