package Win32::AD::Constant;

use Net::LDAP::Control;

use strict;

use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);

$VERSION = '0.01';

use constant LDAP_CONTROL_DIRSYNC		=> '1.2.840.113556.1.4.841';

use constant LDAP_DIRSYNC_INCREMENTAL_VALUES	=> 2147483648;
use constant LDAP_DIRSYNC_PUBLIC_DATA_ONLY	=> 8192;
use constant LDAP_DIRSYNC_ANCESTORS_FIRST_ORDER	=> 2048;
use constant LDAP_DIRSYNC_OBJECT_SECURITY	=> 1;


use constant LDAP_CONTROL_EXTDN			=> '1.2.840.113556.1.4.529';
use constant LDAP_CONTROL_SHOWDELETED		=> '1.2.840.113556.1.4.417';
use constant LDAP_CONTROL_CHGNOTIFICATION	=> '1.2.840.113556.1.4.528';

require Exporter;

@ISA = qw(Exporter);

@EXPORT_OK = qw(LDAP_CONTROL_DIRSYNC
		LDAP_DIRSYNC_INCREMENTAL_VALUES
		LDAP_DIRSYNC_PUBLIC_DATA_ONLY
		LDAP_DIRSYNC_ANCESTORS_FIRST_ORDER
		LDAP_DIRSYNC_OBJECT_SECURITY
		LDAP_CONTROL_EXTDN
		LDAP_CONTROL_SHOWDELETED
		LDAP_CONTROL_CHGNOTIFICATION);

%EXPORT_TAGS =(	all	=> [qw(	LDAP_CONTROL_DIRSYNC
				LDAP_DIRSYNC_INCREMENTAL_VALUES
				LDAP_DIRSYNC_PUBLIC_DATA_ONLY
				LDAP_DIRSYNC_ANCESTORS_FIRST_ORDER
				LDAP_DIRSYNC_OBJECT_SECURITY
				LDAP_CONTROL_EXTDN
				LDAP_CONTROL_SHOWDELETED
				LDAP_CONTROL_CHGNOTIFICATION)],
		DirSync	=> [qw(	LDAP_CONTROL_DIRSYNC
				LDAP_DIRSYNC_INCREMENTAL_VALUES
				LDAP_DIRSYNC_PUBLIC_DATA_ONLY
				LDAP_DIRSYNC_ANCESTORS_FIRST_ORDER
				LDAP_DIRSYNC_OBJECT_SECURITY)],);

1;
